<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services\Auth;

use DeMarketplace\Auth\Exceptions\AuthException;
use DeMarketplace\Auth\Exceptions\TokenNotCreatedException;

interface AuthDriverInterface
{
    /**
     * @return void
     * @throws AuthException
     */
    public function authenticateWithToken(): void;

    /**
     * @param array $credentials
     * @return void
     * @throws AuthException
     */
    public function authenticateWithCredentials(array $credentials = []): void;

    /**
     * @return bool
     */
    public function hasToken(): bool;

    /**
     * @return bool
     */
    public function isTokenValid(): bool;

    /**
     * @return void
     * @throws AuthException
     */
    public function invalidateToken(): void;

    /**
     * @return void
     * @throws AuthException
     */
    public function invalidateTokenForever(): void;

    /**
     * @return string
     * @throws AuthException
     */
    public function refreshToken(): string;

    /**
     * @return string
     * @throws AuthException
     */
    public function refreshTokenAndInvalidateForever(): string;

    /**
     * @param mixed $user
     * @return string
     * @throws TokenNotCreatedException
     */
    public function generateTokenFromUser($user): string;

    /**
     * @param mixed $user
     * @param array $customData
     * @return string
     * @throws TokenNotCreatedException
     */
    public function generateTokenFromUserWithCustomData($user, array $customData = []): string;

    /**
     * @return mixed
     */
    public function getUser();

    /**
     * @return mixed
     */
    public function getAuth();

    /**
     * @param mixed $key
     * @return mixed
     */
    public function getDataFromToken($key);
}
