<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services\Auth;

use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Support\Manager;

class AuthServiceManager extends Manager
{
    /**
     * @return string
     */
    public function getDefaultDriver()
    {
        return 'jwt';
    }

    /**
     * @return AuthDriverInterface
     * @throws BindingResolutionException
     */
    public function createJwtDriver(): AuthDriverInterface
    {
        return new JwtAuthDriver($this->container->make('tymon.jwt.auth'));
    }
}
