<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services;

use DeMarketplace\Auth\Exceptions\AuthException;
use DeMarketplace\Auth\Services\Auth\AuthDriverInterface;

class AuthenticationService implements AuthenticationServiceInterface
{
    /**
     * @var AuthDriverInterface
     */
    private AuthDriverInterface $auth;

    /**
     * @param AuthDriverInterface $auth
     */
    public function __construct(AuthDriverInterface $auth)
    {
        $this->auth = $auth;
    }

    /**
     * @return void
     * @throws AuthException
     */
    public function authenticate(): void
    {
        $this->getDriver()->authenticateWithToken();
    }

    /**
     * @param array $credentials
     * @return void
     * @throws AuthException
     */
    public function login(array $credentials = []): void
    {
        $this->getDriver()->authenticateWithCredentials($credentials);
    }

    /**
     * @return void
     * @throws AuthException
     */
    public function logout(): void
    {
        $this->getDriver()->invalidateToken();
    }

    /**
     * @return mixed|null
     */
    public function getUser()
    {
        return $this->getDriver()->getUser();
    }

    /**
     * @return AuthDriverInterface
     */
    public function getDriver(): AuthDriverInterface
    {
        return $this->auth;
    }
}
