<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services;

use DeMarketplace\Auth\Exceptions\AuthException;

interface AuthenticationServiceInterface
{
    /**
     * @return void
     * @throws AuthException
     */
    public function authenticate(): void;

    /**
     * @param array $credentials
     * @return void
     * @throws AuthException
     */
    public function login(array $credentials = []): void;

    /**
     * @return void
     */
    public function logout(): void;

    /**
     * @return mixed
     */
    public function getUser();
}
