<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Http\Middleware;

use DeMarketplace\Auth\Exceptions\AuthException;
use DeMarketplace\Auth\Exceptions\TokenMissingException;
use DeMarketplace\Auth\Services\Auth\AuthDriverInterface;

class Authenticate
{
    /**
     * @var AuthDriverInterface
     */
    protected AuthDriverInterface $auth;

    /**
     * @param AuthDriverInterface $auth
     */
    public function __construct(AuthDriverInterface $auth)
    {
        $this->auth = $auth;
    }

    /**
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     * @throws AuthException
     */
    public function handle($request, \Closure $next)
    {
        if (!$this->auth->hasToken()) {
            throw new TokenMissingException();
        }

        $this->auth->authenticateWithToken();

        return $next($request);
    }
}
