<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services\Password;

use DeMarketplace\Auth\Exceptions\InvalidCredentialsException;
use DeMarketplace\Auth\Exceptions\InvalidResetPasswordTokenException;
use Illuminate\Contracts\Auth\PasswordBroker;
use Illuminate\Contracts\Auth\PasswordBrokerFactory;

class ResetPasswordByEmailDriver implements ResetPasswordDriverInterface
{
    /**
     * @var PasswordBroker
     */
    private PasswordBroker $broker;

    /**
     * @param PasswordBrokerFactory $brokerFactory
     */
    public function __construct(PasswordBrokerFactory $brokerFactory)
    {
        $this->broker = $brokerFactory->broker();
    }

    /**
     * @param array $credentials
     * @return void
     * @throws InvalidCredentialsException
     */
    public function requestForReset(array $credentials): void
    {
        $response = $this->broker->sendResetLink($credentials);

        if ($response === PasswordBroker::INVALID_USER) {
            throw new InvalidCredentialsException();
        }
    }

    /**
     * @param array $credentials
     * @param \Closure $callback
     * @return void
     * @throws InvalidCredentialsException
     * @throws InvalidResetPasswordTokenException
     */
    public function reset(array $credentials, \Closure $callback): void
    {
        $response = $this->broker->reset($credentials, $callback);

        if ($response === PasswordBroker::INVALID_USER) {
            throw new InvalidCredentialsException();
        }

        if ($response === PasswordBroker::INVALID_TOKEN) {
            throw new InvalidResetPasswordTokenException();
        }
    }
}
