<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services\Password;

use Illuminate\Contracts\Auth\PasswordBrokerFactory;
use Illuminate\Support\Manager;

class ResetPasswordManager extends Manager
{
    /**
     * @return string
     */
    public function getDefaultDriver(): string
    {
        return ResetPasswordDriverInterface::RESET_BY_EMAIL;
    }

    /**
     * @return ResetPasswordDriverInterface
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     */
    public function createEmailDriver(): ResetPasswordDriverInterface
    {
        return new ResetPasswordByEmailDriver($this->container->make(PasswordBrokerFactory::class));
    }
}
