<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Tests;

use DeMarketplace\Auth\Exceptions\AuthException;
use DeMarketplace\Auth\Exceptions\Converter;
use DeMarketplace\Auth\Exceptions\TokenNotCreatedException;
use DeMarketplace\Auth\Exceptions\UnauthorizedException;
use DeMarketplace\Auth\Services\Auth\AuthDriverInterface;

class ExceptionConverterTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @test
     * @return void
     * @throws \ReflectionException
     */
    public function it_converts_auth_exception(): void
    {
        $authDriver = $this->createMock(AuthDriverInterface::class);

        $converter = new Converter($authDriver);

        $this->assertInstanceOf(UnauthorizedException::class, $converter->convert(new AuthException()));
    }

    /**
     * @test
     * @return void
     * @throws \ReflectionException
     */
    public function it_does_not_convert_non_auth_exceptions()
    {
        $authDriver = $this->createMock(AuthDriverInterface::class);

        $converter = new Converter($authDriver);

        $this->assertInstanceOf(TokenNotCreatedException::class, $converter->convert(new TokenNotCreatedException()));
    }
}
