<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services\Password;

use DeMarketplace\Auth\Exceptions\InvalidCredentialsException;
use DeMarketplace\Auth\Exceptions\InvalidResetPasswordTokenException;

interface ResetPasswordDriverInterface
{
    public const RESET_BY_EMAIL = 'email';

    /**
     * @param array $credentials
     * @return void
     * @throws InvalidCredentialsException
     */
    public function requestForReset(array $credentials): void;

    /**
     * @param array $credentials
     * @param \Closure $callback
     * @return void
     * @throws InvalidCredentialsException
     * @throws InvalidResetPasswordTokenException
     */
    public function reset(array $credentials, \Closure $callback): void;
}
