<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Exceptions;

use DeMarketplace\Auth\Services\Auth\AuthDriverInterface;
use DeMarketplace\Support\Exceptions\ConverterInterface;
use Illuminate\Support\Str;

class Converter implements ConverterInterface
{
    /**
     * @var AuthDriverInterface
     */
    private AuthDriverInterface $auth;

    /**
     * @param AuthDriverInterface $auth
     */
    public function __construct(AuthDriverInterface $auth)
    {
        $this->auth = $auth;
    }

    /**
     * @param \Throwable $e
     * @return \Throwable
     * @throws \ReflectionException
     */
    public function convert(\Throwable $e): \Throwable
    {
        if ($e instanceof AuthException) {
            $authDriverClass = (new \ReflectionClass($this->auth))->getShortName();
            $challenge = Str::snake(str_replace('Driver', '', $authDriverClass));

            return UnauthorizedException::fromAuthException($challenge, $e);
        }

        return $e;
    }
}