<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Exceptions;

use DeMarketplace\Support\Exceptions\IsResponsable;
use Illuminate\Contracts\Support\Responsable;
use Symfony\Component\HttpKernel\Exception\UnauthorizedHttpException;

class UnauthorizedException extends UnauthorizedHttpException implements Responsable
{
    use IsResponsable;

    /**
     * @param string $challenge
     * @param AuthException $e
     * @return UnauthorizedException
     */
    public static function fromAuthException(string $challenge, AuthException $e): UnauthorizedException
    {
        return new self($challenge, $e->getMessage());
    }
}
