<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services;

use Illuminate\Auth\Events\Registered;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Config\Repository as Config;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Contracts\Hashing\Hasher;
use Illuminate\Database\Eloquent\Model;

class RegistrationService implements RegistrationServiceInterface
{
    /**
     * @var Config
     */
    private Config $config;

    /**
     * @var Dispatcher
     */
    private Dispatcher $dispatcher;

    /**
     * @var Hasher
     */
    private Hasher $hasher;

    /**
     * @param Config $config
     * @param Dispatcher $dispatcher
     * @param Hasher $hasher
     */
    public function __construct(Config $config, Dispatcher $dispatcher, Hasher $hasher)
    {
        $this->config = $config;
        $this->dispatcher = $dispatcher;
        $this->hasher = $hasher;
    }

    /**
     * @param array $data
     * @return Authenticatable
     */
    public function register(array $data = []): Authenticatable
    {
        if (isset($data['password'])) {
            $data['password'] = $this->hasher->make($data['password']);
        }

        $class = '\\' . ltrim($this->config->get('auth.providers.users.model'), '\\');

        /** @var Model|Authenticatable $authenticatableModel */
        $authenticatableModel = new $class();
        $authenticatableModel = $authenticatableModel->query()->create($data);

        $this->dispatcher->dispatch(new Registered($authenticatableModel));

        return $authenticatableModel;
    }
}
