<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Tests;

use DeMarketplace\Auth\Services\RegistrationService;
use DeMarketplace\Auth\Tests\Stubs\UserModel;
use Illuminate\Contracts\Config\Repository;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Contracts\Hashing\Hasher;

class RegistrationServiceTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @test
     * @return void
     */
    public function it_registers_new_user(): void
    {
        $user = new UserModel([
            'first_name' => 'Luke',
            'last_name' => 'Skywalker',
            'password' => 'luke_skywalker_hashed_password',
        ]);

        $config = $this->createMock(Repository::class);
        $config->expects($this->once())
            ->method('get')
            ->with('auth.providers.users.model')
            ->willReturn(get_class($user));

        $dispatcher = $this->createMock(Dispatcher::class);
        $dispatcher->expects($this->once())->method('dispatch');

        $hasher = $this->createMock(Hasher::class);
        $hasher->expects($this->once())
            ->method('make')
            ->with('vader_is_not_my_father')
            ->willReturn('luke_skywalker_hashed_password');

        $registeredUser = (new RegistrationService($config, $dispatcher, $hasher))->register([
            'first_name' => 'Luke',
            'last_name' => 'Skywalker',
            'password' => 'vader_is_not_my_father'
        ]);

        $this->assertEquals($user->getAttributes(), $registeredUser->getAttributes());
    }
}
