<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Services;

interface PasswordServiceInterface
{
    /**
     * @param array $credentials
     * @return void
     */
    public function requestForReset(array $credentials): void;

    /**
     * @param array $credentials
     * @return void
     */
    public function reset(array $credentials): void;

    /**
     * @param string $resetPasswordMethod
     * @return PasswordServiceInterface
     */
    public function setResetPasswordMethod(string $resetPasswordMethod): self;
}
