<?php

declare(strict_types=1);

namespace DeMarketplace\Auth\Tests;

use DeMarketplace\Auth\Services\Auth\AuthDriverInterface;
use DeMarketplace\Auth\Services\AuthenticationService;

class AuthenticationServiceTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @test
     * @return void
     */
    public function it_authenticates_user_by_token(): void
    {
        $user = new class {};

        $authDriver = $this->createMock(AuthDriverInterface::class);
        $authDriver->expects($this->once())->method('authenticateWithToken');
        $authDriver->expects($this->once())->method('getUser')->willReturn($user);

        $authenticationService = new AuthenticationService($authDriver);
        $authenticationService->authenticate();

        $this->assertEquals($user, $authenticationService->getUser());
    }

    /**
     * @test
     * @return void
     */
    public function it_authenticates_user_by_credentials(): void
    {
        $user = new class {};

        $authDriver = $this->createMock(AuthDriverInterface::class);
        $authDriver->expects($this->once())->method('authenticateWithCredentials')->with(['login' => 'login', 'password' => 'password']);
        $authDriver->expects($this->once())->method('getUser')->willReturn($user);

        $authenticationService = new AuthenticationService($authDriver);
        $authenticationService->login(['login' => 'login', 'password' => 'password']);

        $this->assertEquals($user, $authenticationService->getUser());
    }
}
