<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Direct Debit Provider
    |--------------------------------------------------------------------------
    |
    | Here you can configure provider that supports direct debit
    | transactions. Direct debit is a financial transaction in
    | which one person (or company) withdraws funds.
    |
    | Supported Drivers: "go_cardless"
    |
    */

    'provider' => 'go_cardless',

    /*
    |--------------------------------------------------------------------------
    | GoCardless Settings
    |--------------------------------------------------------------------------
    |
    | Here you can configure all the settings required to communicate
    | and exchange required information between the application
    | and GoCardless (direct debit) company.
    |
    */

    'go_cardless' => [
        'company_name' => env('GO_CARDLESS_COMPANY_NAME'),
        'access_token' => env('GO_CARDLESS_ACCESS_TOKEN'),
        'environment' => env('GO_CARDLESS_ENVIRONMENT', \GoCardlessPro\Environment::SANDBOX),
        'webhook_secret' => env('GO_CARDLESS_WEBHOOK_SECRET'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Logging Settings
    |--------------------------------------------------------------------------
    |
    | This section allows to enable or disable logging related with direct debit
    | payments. It also allows to define the log channel that gets used when
    | writing messages to the logs (null value equals default channel).
    |
    */

    'logging' => [
        'enabled' => env('DIRECT_DEBIT_LOGGING_ENABLED', false),
        'channel' => env('DIRECT_DEBIT_LOGGING_CHANNEL'),
    ],

];