<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit;

use DeMarketplace\Payments\DirectDebit\Exceptions\RedirectFlowException;
use DeMarketplace\Payments\DirectDebit\Models\DirectDebitCustomerInterface;
use DeMarketplace\Payments\DirectDebit\Processors\RedirectFlow\RedirectFlowProcessorInterface;

class DirectDebitService implements DirectDebitServiceInterface
{
    /**
     * @var RedirectFlowProcessorInterface
     */
    private RedirectFlowProcessorInterface $redirectFlowProcessor;

    /**
     * @param RedirectFlowProcessorInterface $redirectFlowProcessor
     */
    public function __construct(RedirectFlowProcessorInterface $redirectFlowProcessor)
    {
        $this->redirectFlowProcessor = $redirectFlowProcessor;
    }

    /**
     * @param DirectDebitCustomerInterface $user
     * @param string $successRedirectUrl
     * @return string
     * @throws RedirectFlowException
     */
    public function createRedirectFlow(DirectDebitCustomerInterface $user, string $successRedirectUrl): string
    {
        return $this->redirectFlowProcessor->start($user, $successRedirectUrl);
    }

    /**
     * @param DirectDebitCustomerInterface $user
     * @param string $redirectFlowId
     * @return string
     * @throws RedirectFlowException
     */
    public function completeRedirectFlow(DirectDebitCustomerInterface $user, string $redirectFlowId): string
    {
        return $this->redirectFlowProcessor->complete($user, $redirectFlowId);
    }
}
