<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit;

use DeMarketplace\Payments\DirectDebit\Exceptions\RedirectFlowException;
use DeMarketplace\Payments\DirectDebit\Models\DirectDebitCustomerInterface;

interface DirectDebitServiceInterface
{
    /**
     * @param DirectDebitCustomerInterface $user
     * @param string $successRedirectUrl
     * @return string
     * @throws RedirectFlowException
     */
    public function createRedirectFlow(DirectDebitCustomerInterface $user, string $successRedirectUrl): string;

    /**
     * @param DirectDebitCustomerInterface $user
     * @param string $redirectFlowId
     * @return string
     * @throws RedirectFlowException
     */
    public function completeRedirectFlow(DirectDebitCustomerInterface $user, string $redirectFlowId): string;
}