<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Events;

class IncomingMandatesWebhook
{
    /**
     * @var string
     */
    private string $directDebitProvider;

    /**
     * @var array
     */
    private array $data;

    /**
     * @param string $directDebitProvider
     * @param array $data
     */
    public function __construct(string $directDebitProvider, array $data)
    {
        $this->directDebitProvider = $directDebitProvider;
        $this->data = $data;
    }

    /**
     * @return string
     */
    public function getDirectDebitProvider(): string
    {
        return $this->directDebitProvider;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }
}