<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Http\Actions;

use DeMarketplace\Payments\DirectDebit\Processors\Webhook\WebhookProcessorInterface;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class HandleWebhookAction
{
    /**
     * @param Request $request
     * @param WebhookProcessorInterface $webhookProcessor
     * @return JsonResponse
     */
    public function __invoke(Request $request, WebhookProcessorInterface $webhookProcessor): JsonResponse
    {
        return $webhookProcessor->process($request);
    }
}