<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Log;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;
use Illuminate\Log\LogManager;
use Illuminate\Support\Arr;
use Psr\Log\LoggerInterface;

class Logger implements LoggerInterface
{
    /**
     * @var LogManager
     */
    private LogManager $logger;

    /**
     * @var array
     */
    private array $config;

    /**
     * @param LogManager $logger
     * @param array $config
     */
    public function __construct(LogManager $logger, array $config)
    {
        $this->logger = $logger;
        $this->config = $config;
    }

    /**
     * @param string $message
     * @param array $context
     * @return void
     */
    public function emergency($message, array $context = []): void
    {
        $this->writeLog(__FUNCTION__, $message, $context);
    }

    /**
     * @param string $message
     * @param array $context
     * @return void
     */
    public function alert($message, array $context = []): void
    {
        $this->writeLog(__FUNCTION__, $message, $context);
    }

    /**
     * @param string $message
     * @param array $context
     * @return void
     */
    public function critical($message, array $context = []): void
    {
        $this->writeLog(__FUNCTION__, $message, $context);
    }

    /**
     * @param string $message
     * @param array $context
     * @return void
     */
    public function error($message, array $context = []): void
    {
        $this->writeLog(__FUNCTION__, $message, $context);
    }

    /**
     * @param string $message
     * @param array $context
     * @return void
     */
    public function warning($message, array $context = []): void
    {
        $this->writeLog(__FUNCTION__, $message, $context);
    }

    /**
     * @param string $message
     * @param array $context
     * @return void
     */
    public function notice($message, array $context = []): void
    {
        $this->writeLog(__FUNCTION__, $message, $context);
    }

    /**
     * @param string $message
     * @param array $context
     * @return void
     */
    public function info($message, array $context = []): void
    {
        $this->writeLog(__FUNCTION__, $message, $context);
    }

    /**
     * @param string $message
     * @param array $context
     * @return void
     */
    public function debug($message, array $context = []): void
    {
        $this->writeLog(__FUNCTION__, $message, $context);
    }

    /**
     * @param string $level
     * @param string $message
     * @param array $context
     * @return void
     */
    public function log($level, $message, array $context = []): void
    {
        $this->writeLog($level, $message, $context);
    }

    /**
     * @param string $level
     * @param string $message
     * @param array $context
     * @return void
     */
    protected function writeLog($level, $message, $context)
    {
        if (!Arr::get($this->config, 'enabled', false)) {
            return ;
        }

        $channel = Arr::get($this->config, 'channel');

        /** @var LoggerInterface $logger */
        $logger = $this->logger->channel($channel);
        $logger->{$level}($this->formatMessage($message), $context);
    }

    /**
     * @param mixed $message
     * @return mixed
     */
    protected function formatMessage($message)
    {
        if (is_array($message)) {
            return var_export($message, true);
        } elseif ($message instanceof Jsonable) {
            return $message->toJson();
        } elseif ($message instanceof Arrayable) {
            return var_export($message->toArray(), true);
        }

        return $message;
    }
}