<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Models;

interface DirectDebitCustomerInterface
{
    /**
     * @return int|string
     */
    public function getIdentifier();

    /**
     * @return string
     */
    public function getGivenName(): string;

    /**
     * @return string
     */
    public function getFamilyName(): string;

    /**
     * @return string
     */
    public function getEmail(): string;

    /**
     * @return string
     */
    public function getAddressLine(): string;

    /**
     * @return string
     */
    public function getCity(): string;

    /**
     * @return string
     */
    public function getPostalCode(): string;
}