<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Models;

use Illuminate\Support\Str;

/**
 * @method static DirectDebitMandateStatus none()
 * @method static DirectDebitMandateStatus pending()
 * @method static DirectDebitMandateStatus processing()
 * @method static DirectDebitMandateStatus active()
 * @method static DirectDebitMandateStatus inactive()
 */
class DirectDebitMandateStatus
{
    const NONE = 'none';
    const PENDING = 'pending';
    const PROCESSING = 'processing';
    const ACTIVE = 'active';
    const INACTIVE = 'inactive';

    /**
     * @var string
     */
    protected string $status;

    /**
     * @param string $status
     */
    private function __construct(string $status)
    {
        $this->status = $status;
    }

    /**
     * @param string $name
     * @param array $arguments
     * @return DirectDebitMandateStatus
     * @throws \LogicException
     */
    public static function __callStatic($name, $arguments)
    {
        $constName = sprintf('%s::%s', __CLASS__, strtoupper(Str::snake($name)));

        if (!defined($constName)) {
            throw new \LogicException('Undefined type: ' . $constName);
        }

        $status = constant($constName);

        return new static($status);
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->status;
    }

    /**
     * @param DirectDebitMandateStatus $otherStatus
     * @return bool
     */
    public function equals(DirectDebitMandateStatus $otherStatus): bool
    {
        return $this->status === $otherStatus->status;
    }
}
