<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * @mixin Model
 */
trait IsDirectDebitCustomer
{
    /**
     * @return int|string
     */
    public function getIdentifier()
    {
        return $this->getKey();
    }

    /**
     * @return string
     */
    public function getGivenName(): string
    {
        return $this->getAttribute('first_name');
    }

    /**
     * @return string
     */
    public function getFamilyName(): string
    {
        return $this->getAttribute('last_name');
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->getAttribute('email');
    }

    /**
     * @return string
     */
    public function getAddressLine(): string
    {
        return $this->getAttribute('address_line1');
    }

    /**
     * @return string
     */
    public function getCity(): string
    {
        return $this->getAttribute('city');
    }

    /**
     * @return string
     */
    public function getPostalCode(): string
    {
        return $this->getAttribute('postal_code');
    }

    /**
     * @param DirectDebitMandateStatus|string $status
     * @return void
     */
    public function setDirectDebitMandateStatusAttribute($status): void
    {
        if (!$status instanceof DirectDebitMandateStatus) {
            $status = DirectDebitMandateStatus::$status();
        }

        $this->attributes[$this->getDirectDebitMandateStatusFillableAttribute()] = (string) $status;
    }

    /**
     * @param string $status
     * @return DirectDebitMandateStatus
     */
    public function getDirectDebitMandateStatusAttribute(string $status): DirectDebitMandateStatus
    {
        return DirectDebitMandateStatus::$status();
    }

    /**
     * @return DirectDebitMandateStatus
     */
    public function getDirectDebitMandateStatus(): DirectDebitMandateStatus
    {
        return $this->getAttribute($this->getDirectDebitMandateStatusFillableAttribute());
    }

    /**
     * @return string
     */
    protected function getDirectDebitMandateIdFillableAttribute(): string
    {
        return 'direct_debit_mandate_id';
    }

    /**
     * @return string
     */
    protected function getDirectDebitMandateStatusFillableAttribute(): string
    {
        return 'direct_debit_mandate_status';
    }
}