<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Processors\RedirectFlow;

use DeMarketplace\Payments\DirectDebit\Exceptions\RedirectFlowException;
use DeMarketplace\Payments\DirectDebit\Models\DirectDebitCustomerInterface;

interface RedirectFlowProcessorInterface
{
    /**
     * @param DirectDebitCustomerInterface $user
     * @param string $successRedirectUrl
     * @return string
     * @throws RedirectFlowException
     */
    public function start(DirectDebitCustomerInterface $user, string $successRedirectUrl): string;

    /**
     * @param DirectDebitCustomerInterface $user
     * @param string $redirectFlowId
     * @return string
     * @throws RedirectFlowException
     */
    public function complete(DirectDebitCustomerInterface $user, string $redirectFlowId): string;
}
