<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Processors\RedirectFlow;

use DeMarketplace\Payments\DirectDebit\Log\Logger;
use GoCardlessPro\Client;
use Illuminate\Support\Manager;

class RedirectFlowProcessorManager extends Manager
{
    /**
     * @return string
     */
    public function getDefaultDriver(): string
    {
        return 'go_cardless';
    }

    /**
     * @return RedirectFlowProcessorInterface
     */
    public function createGoCardlessDriver(): RedirectFlowProcessorInterface
    {
        return new GoCardlessRedirectFlowProcessor(
            $this->container->get(Client::class),
            $this->container['config'],
            $this->container->get(Logger::class)
        );
    }
}
