<?php

declare(strict_types=1);

namespace DeMarketplace\Payments\DirectDebit\Processors\Webhook;

use DeMarketplace\Payments\DirectDebit\Log\Logger;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Support\Manager;

class WebhookProcessorManager extends Manager
{
    /**
     * @return string
     */
    public function getDefaultDriver()
    {
        return 'go_cardless';
    }

    /**
     * @return WebhookProcessorInterface
     */
    public function createGoCardlessDriver(): WebhookProcessorInterface
    {
        return new GoCardlessWebhookProcessor(
            $this->container->get(Dispatcher::class),
            $this->container->get(Logger::class),
            $this->container['config']['direct-debit-payments.go_cardless.webhook_secret']
        );
    }
}
