<?php

declare(strict_types=1);

namespace DeMarketplace\Products\Models\Concerns;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

/**
 * @mixin Model
 */
trait HasConfigurable
{
    /**
     * @return HasOneThrough
     */
    public function configurable(): HasOneThrough
    {
        return $this->hasOneThrough(
            static::class,
            $this->getVariantClassName(),
            $this->getVariantKeyInPivotTableForConfigurable(),
            $this->getProductKeyInMainTableForConfigurable(),
            '',
            $this->getProductKeyInPivotTableForConfigurable()
        );
    }

    /**
     * @return string
     */
    protected function getProductKeyInMainTableForConfigurable(): string
    {
        return property_exists($this, 'productKeyInMainTable') ? $this->productKeyInMainTable : 'id';
    }

    /**
     * @return string
     */
    protected function getProductKeyInPivotTableForConfigurable(): string
    {
        return property_exists($this, 'productKeyInPivotTable') ? $this->productKeyInPivotTable : 'product_id';
    }

    /**
     * @return string
     */
    protected function getVariantKeyInPivotTableForConfigurable(): string
    {
        return property_exists($this, 'variantKeyInPivotTable') ? $this->variantKeyInPivotTable : 'variant_id';
    }

    /**
     * @return string
     */
    protected function getVariantClassName(): string
    {
        $productVariantClassName = trim(static::class, '\\') . 'Variant';

        if (class_exists($productVariantClassName)) {
            return $productVariantClassName;
        }

        throw new \RuntimeException("Missing product variant class [$productVariantClassName].");
    }
}