<?php

declare(strict_types=1);

namespace DeMarketplace\Products\Models\Concerns;

use Illuminate\Database\Eloquent\Model;

/**
 * @mixin Model
 */
trait HasSuperAttributes
{
    /**
     * @return string
     */
    public function getHasSuperAttributesFillableAttribute(): string
    {
        return 'super_attributes';
    }

    /**
     * @return array
     */
    public function getCasts(): array
    {
        $casts = parent::getCasts();

        if (!array_key_exists('super_attributes', $casts)) {
            return array_merge(['super_attributes' => 'json'], $casts);
        }

        return $casts;
    }

    /**
     * @return array
     */
    public function getSuperAttributes(): array
    {
        return $this->getAttribute($this->getHasSuperAttributesFillableAttribute());
    }
}
