<?php

declare(strict_types=1);

namespace DeMarketplace\Products\Models\Concerns;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

/**
 * @mixin Model
 */
trait HasVariants
{
    /**
     * @return BelongsToMany
     */
    public function variants(): BelongsToMany
    {
        return $this->belongsToMany(
            static::class,
            $this->getProductVariantTable(),
            $this->getProductKeyInPivotTableForVariants(),
            $this->getVariantKeyInPivotTableForVariants(),
        );
    }

    /**
     * @return string
     */
    protected function getProductKeyInPivotTableForVariants(): string
    {
        return property_exists($this, 'productKeyInPivotTable') ? $this->productKeyInPivotTable : 'product_id';
    }

    /**
     * @return string
     */
    protected function getVariantKeyInPivotTableForVariants(): string
    {
        return property_exists($this, 'variantKeyInPivotTable') ? $this->variantKeyInPivotTable : 'variant_id';
    }

    /**
     * @return string
     */
    protected function getProductVariantTable(): string
    {
        $physicalProductVariantClass = trim(static::class, '\\') . 'Variant';

        if (class_exists($physicalProductVariantClass)) {
            /** @var Model $physicalProductVariant */
            $physicalProductVariant = new $physicalProductVariantClass;

            return $physicalProductVariant->getTable();
        }

        throw new \RuntimeException("Missing product variant class [$physicalProductVariantClass].");
    }
}