<?php

declare(strict_types=1);

namespace DeMarketplace\Products\Models\Concerns;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

/**
 * @mixin Model
 */
trait IsConfigurableProduct
{
    use HasSuperAttributes,
        HasVariants;

    /**
     * @var string
     */
    protected string $variantKeyInPivotTable = 'variant_id';

    /**
     * @var string
     */
    protected string $productKeyInPivotTable = 'product_id';

    /**
     * @return string
     */
    protected function getIsConfigurableProductFillableAttribute(): string
    {
        return 'is_configurable';
    }

    /**
     * @return bool
     */
    public function isConfigurable(): bool
    {
        return (bool) $this->getAttribute($this->getIsConfigurableProductFillableAttribute());
    }

    /**
     * @return bool
     */
    public function isSimple(): bool
    {
        return !$this->isConfigurable();
    }
}
