<?php

declare(strict_types=1);

namespace DeMarketplace\Products\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;

class Product extends Model
{
    /**
     * @var bool
     */
    public static bool $traitsAttributesInitialized = false;

    /**
     * @var array
     */
    public static array $traitsFillableAttributes = [];

    /**
     * @return array
     */
    public function getFillable(): array
    {
        if (!self::$traitsAttributesInitialized) {
            foreach (class_uses_recursive($this) as $trait) {
                $method = 'get' . class_basename($trait) . 'FillableAttribute';

                if (method_exists($this, $method)) {
                    self::$traitsFillableAttributes = array_merge(
                        self::$traitsFillableAttributes,
                        Arr::wrap($this->{$method}())
                    );
                }
            }

            self::$traitsAttributesInitialized = true;
        }

        return array_unique(array_merge($this->fillable, self::$traitsFillableAttributes));
    }
}
