<?php

declare(strict_types=1);

namespace DeMarketplace\Support\Tests;

use DeMarketplace\Support\Mappers\CollectionObjectMapper;
use Illuminate\Support\Collection;

class CollectionObjectMapperTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @test
     * @return void
     */
    public function it_maps_collection_object(): void
    {
        $collection = new Collection([
            [
                'best_sw_movie' => 'The Empire Strikes Back',
                'best_sw_character' => 'Darth Vader',
            ],
            [
                'best_sw_movie' => 'New Hope',
                'best_sw_character' => 'Leia Organa',
            ]
        ]);

        $expectedResult = [
            [
                'best_sw_movie' => 'The Empire Strikes Back',
                'best_sw_character' => 'Darth Vader',
            ],
            [
                'best_sw_movie' => 'New Hope',
                'best_sw_character' => 'Leia Organa',
            ]
        ];

        $this->assertEquals($expectedResult, (new CollectionObjectMapper())->map('cash', $collection));
    }
}
