<?php

declare(strict_types=1);

namespace DeMarketplace\Support\Mappers;

use DeMarketplace\Support\MoneyFactory;
use Money\Money;

class MoneyObjectMapper implements MapperInterface
{
    /**
     * @param string $key
     * @param mixed $data
     * @return array
     */
    public function map(string $key, $data): ?array
    {
        if ($data instanceof Money) {
            return [$key => MoneyFactory::jsonSerialize($data)];
        }

        return null;
    }
}