<?php

declare(strict_types=1);

namespace DeMarketplace\Support;

use DeMarketplace\Support\Mappers\DefaultMapper;
use DeMarketplace\Support\Mappers\MapperInterface;
use Illuminate\Support\Collection;

class MappableCollection extends Collection
{
    /**
     * @var MapperInterface[]|array
     */
    private static array $mappers = [];

    /**
     * @param MapperInterface $mapper
     * @return void
     */
    public static function registerMapper(MapperInterface $mapper)
    {
        static::$mappers[] = $mapper;
    }

    /**
     * @return void
     */
    public static function cleanMappers()
    {
        static::$mappers = [];
    }

    /**
     * @param array $data
     * @return MappableCollection
     */
    public static function mapWithMappers(array $data): MappableCollection
    {
        return (new static($data))->mapWithKeys(function ($data, string $key) {
            foreach (array_reverse(static::$mappers) as $mapper) {
                $result = $mapper->map($key, $data);

                if (!is_null($result)) {
                    return $result;
                }
            }

            return (new DefaultMapper())->map($key, $data);
        });
    }
}