<?php

declare(strict_types=1);

namespace DeMarketplace\Support\Tests;

use DeMarketplace\Support\HMAC;

class HMACTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @test
     * @return void
     */
    public function it_creates_hmac(): void
    {
        $hmac = HMAC::create('hashkey', 'some dummy string to hash');

        $this->assertIsString((string) $hmac);
    }

    /**
     * @test
     * @return void
     */
    public function it_compares_hmacs(): void
    {
        $hmac = HMAC::create('hashkey', 'some dummy string to hash');

        $equalHmac = hash_hmac('sha256', 'some dummy string to hash', 'hashkey');
        $equalHmacFromHash = HMAC::createFromHash('hashkey', $equalHmac);

        $notEqualHmac = hash_hmac('sha256', 'some dummy string to hash', 'modifiedhashkey');
        $notEqualHmacFromHash = HMAC::createFromHash('modifiedhashkey', $notEqualHmac);

        $this->assertTrue($hmac->isEqual($equalHmacFromHash));
        $this->assertFalse($hmac->isEqual($notEqualHmacFromHash));
    }
}
