<?php

declare(strict_types=1);

namespace DeMarketplace\Support\Tests;

use DeMarketplace\Support\Mappers\MoneyObjectMapper;
use Money\Currency;
use Money\Money;

class MoneyObjectMapperTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @test
     * @return void
     */
    public function it_maps_money_object(): void
    {
        $expectedResult = [
            'cash' => [
                'amount' => '1000',
                'currency' => new Currency('GBP'),
                'formatted' => '£ 10',
                'float' => 10.0
            ]
        ];

        $this->assertEquals($expectedResult, (new MoneyObjectMapper())->map('cash', Money::GBP(1000)));
    }
}
