<?php

declare(strict_types=1);

namespace DeMarketplace\Support\Mappers;

use Illuminate\Support\Collection;

class CollectionObjectMapper implements MapperInterface
{
    /**
     * @param string $key
     * @param mixed $data
     * @return array|null
     */
    public function map(string $key, $data): ?array
    {
        if ($data instanceof Collection) {
            return $data->jsonSerialize();
        }

        return null;
    }
}