<?php

declare(strict_types=1);

namespace DeMarketplace\Support;

use DeMarketplace\Support\Mappers\CollectionObjectMapper;
use DeMarketplace\Support\Mappers\MoneyObjectMapper;
use DeMarketplace\Support\Mappers\StringableObjectMapper;
use Illuminate\Support\ServiceProvider;

class SupportServiceProvider extends ServiceProvider
{
    /**
     * @return void
     */
    public function register(): void
    {
        //
    }

    /**
     * @return void
     */
    public function boot(): void
    {
        MappableCollection::registerMapper(new StringableObjectMapper());
        MappableCollection::registerMapper(new CollectionObjectMapper());
        MappableCollection::registerMapper(new MoneyObjectMapper());
    }
}
