<?php

declare(strict_types=1);

namespace DeMarketplace\Support\Tests;

use DeMarketplace\Support\MappableCollection;
use DeMarketplace\Support\Mappers\CollectionObjectMapper;
use DeMarketplace\Support\Mappers\MoneyObjectMapper;
use DeMarketplace\Support\Mappers\StringableObjectMapper;
use Illuminate\Support\Collection;
use Money\Currency;
use Money\Money;

class MappableCollectionTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @test
     * @return void
     */
    public function it_maps_objects(): void
    {
        MappableCollection::registerMapper(new CollectionObjectMapper());
        MappableCollection::registerMapper(new MoneyObjectMapper());
        MappableCollection::registerMapper(new StringableObjectMapper());

        $dataToMap = [
            'collection_object' => new Collection([
                [
                    'best_sw_movie' => 'The Empire Strikes Back',
                    'best_sw_character' => 'Darth Vader',
                ],
                [
                    'best_sw_movie' => 'New Hope',
                    'best_sw_character' => 'Leia Organa',
                ]
            ]),
            'money_object' => Money::GBP(1000),
            'stringable_object' => new class {
                public function __toString()
                {
                    return 'Hey! It\'s me!';
                }
            },
            'default' => 3
        ];

        $expextedResult = [
            'collection_object' => json_encode([
                [
                    'best_sw_movie' => 'The Empire Strikes Back',
                    'best_sw_character' => 'Darth Vader',
                ],
                [
                    'best_sw_movie' => 'New Hope',
                    'best_sw_character' => 'Leia Organa',
                ],
            ]),
            'money_object' => [
                'amount' => 1000,
                'currency' => new Currency('GBP'),
                'formatted' => '£ 10',
                'float' => 10.0
            ],
            'stringable_object' => 'Hey! It\'s me!',
            'default' => 3
        ];

        $this->assertEquals($expextedResult, MappableCollection::mapWithMappers($dataToMap)->toArray());
    }
}
