<?php

declare(strict_types=1);

namespace DeMarketplace\Support\Tests;

use DeMarketplace\Support\Mappers\StringableObjectMapper;

class StringableObjectMapperTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @test
     * @return void
     */
    public function it_maps_stringable_object(): void
    {
        $object = new class {
            public function __toString()
            {
                return 'Hey! It\'s me!';
            }
        };

        $this->assertEquals(['message' => 'Hey! It\'s me!'], (new StringableObjectMapper())->map('message', $object));
    }
}
