<?php

namespace DeMarketplace\Support\Exceptions;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

trait IsResponsable
{
    /**
     * @var \Closure|null
     */
    public static ?\Closure $toResponseCallback = null;

    /**
     * @param Request $request
     * @return JsonResponse
     */
    public function toResponse($request): JsonResponse
    {
        if (null !== static::$toResponseCallback) {
            return call_user_func(static::$toResponseCallback, $request);
        }

        return new JsonResponse([
            'message' => method_exists($this, 'getMessage') ? $this->getMessage() : 'Error.',
        ], method_exists($this, 'getStatusCode') ? $this->getStatusCode() : 500);
    }
}