<?php

declare(strict_types=1);

namespace DeMarketplace\Support\Mappers;

class StringableObjectMapper implements MapperInterface
{
    /**
     * @param string $key
     * @param mixed $data
     * @return array|null
     */
    public function map(string $key, $data): ?array
    {
        if (is_object($data) && method_exists($data, '__toString')) {
            return [$key => (string) $data];
        }

        return null;
    }
}